// Karma configuration
// http://karma-runner.github.io/0.10/config/configuration-file.html

module.exports = function(config) {
  config.set({
    // base path, that will be used to resolve files and exclude
    basePath: '',

    // testing framework to use (jasmine/mocha/qunit/...)
    frameworks: ['jasmine', 'requirejs'],

    plugins: [
      'karma-requirejs',
      'karma-chrome-launcher',
      'karma-phantomjs-launcher',
      'karma-jasmine',
      'karma-junit-reporter',
      'karma-threshold-reporter',
      'karma-coverage'
    ],

    // list of files / patterns to load in the browser
    files: [
      './node_modules/phantomjs-polyfill/bind-polyfill.js',
      {pattern: 'veteran-appointment-requests/app/**/*.js', included: false },
      {pattern: 'veteran-appointment-requests/app/js/tools/*.js', included: false },
      {pattern: 'veteran-appointment-requests/app/**/*.json', included: false },
      {pattern: 'veteran-appointment-requests/app/**/*.html', included: false },
      {pattern: 'veteran-appointment-requests/libs/**/*.js', included: false },
      {pattern: 'veteran-appointment-requests/test/spec_helpers/*', included: false },
      {pattern: 'veteran-appointment-requests/resource-directory.json', included: false },
      {pattern: 'veteran-appointment-requests/version.json', included: false },
      'veteran-appointment-requests/test/testconfig.js'
    ],

    // list of files / patterns to exclude
    exclude: [
        'veteran-appointment-requests/test/specs/testConfig.js',
        'veteran-appointment-requests/app/config.js'
    ],

    // web server port
    port: 8008,

    // level of logging
    // possible values: LOG_DISABLE || LOG_ERROR || LOG_WARN || LOG_INFO || LOG_DEBUG
    logLevel: config.LOG_INFO,


    // enable / disable watching file and executing tests whenever any file changes
    autoWatch: false,


    // Start these browsers, currently available:
    // - Chrome
    // - ChromeCanary
    // - Firefox
    // - Opera
    // - Safari (only Mac)
    // - PhantomJS
    // - IE (only Windows)
    browsers: ['PhantomJS'],


    // Continuous Integration mode
    // if true, it capture browsers, run tests and exit
    singleRun: true,

    reporters: ['progress' , 'junit', 'coverage', 'threshold'],

    preprocessors: {
      'veteran-appointment-requests/app/**/!(*spec|*helper).js' : ['coverage']
    },

    coverageReporter: {
        reporters: [
        {  type : 'lcov', dir:'coverage/', subdir: '.'},
        {  type : 'cobertura' }],
        includeAllSources: true
    },

    thresholdReporter: {
        statements: 0,
        branches: 0,
        functions: 0,
        lines: 0
    },

    // the default configuration. Generates the junit test report.
    junitReporter: {
        outputFile: 'coverage/junit-test-results.xml',
        suite: ''
    }
  });
};
